<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/** Include the parent model */
require_once 'distribution_list_model.php';

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Private_distribution_list_model extends Distribution_list_model {
	var $table_name = 'distribution_lists';
	
	
	/////////////////////////////
	// SEARCH
	/////////////////////////////
	
	protected function _find($criteria){
		//private lists should only be viewable to the user who created them.
		$criteria['created_by'] = $this->logged_in_user_id();
		return $this->db->get_where($this->table_name, $criteria)->result_array();
	}

	/** overrides parent to make use of more efficient db functionality */
	function exists($id_or_criteria){
		if(!is_array($id_or_criteria) && !$this->formatted_like_an_id($id_or_criteria)) return $this->error->should_be_an_id_or_search_criteria($id_or_criteria);
		$criteria = $this->_criteria_for_find_one($id_or_criteria);
		$criteria['created_by'] = $this->logged_in_user_id();
		$count = $this->db->where($criteria)->from($this->table_name)->count_all_results();
		return $this->is->nonzero_unsigned_integer($count);
	}

	
	///////////////////////////////////
	// MANAGE LIST C.R.U.D.
	///////////////////////////////////

	protected function _values_are_valid_for_create(&$values){
		if(!parent::_values_are_valid_for_create($values)) return false;
		
		//set default values for optional fields
		$default_values = array('created_by' => $this->logged_in_user_id(), 'created_at' => time(), 'modified_at' => time());
		$values = array_merge($default_values, $values);		
					
		//check that we have the right values (name & description checked by parent)
		extract($values);
		if(!$this->is->nonzero_unsigned_integer($created_by)) return $this->error->should_be_a_nonzero_unsigned_integer($created_by);
		if(!$this->is->unix_timestamp($created_at)) return $this->error->should_be_a_unix_timestamp($created_at);
		if(!$this->is->unix_timestamp($modified_at)) return $this->error->should_be_a_unix_timestamp($modified_at);
		
		return true;
	}
	
	protected function _create($values){
		$success = $this->db->insert('distribution_lists', $values); 
		if(!$success) return false;
		return $this->db->insert_id();
	}
	
	protected function _values_are_valid_for_update($list, &$values){
		if(!parent::_values_are_valid_for_update($list, $values)) return false;
	
		if(array_key_exists('created_by', $values) && !$this->is->nonzero_unsigned_integer($values['created_by'])) 
			return $this->error->should_be_a_nonzero_unsigned_integer($values['created_by']);
		if(array_key_exists('created_at', $values) && !$this->is->unix_timestamp($values['created_at'])) 
			return $this->error->should_be_a_unix_timestamp($values['created_at']);
		if(array_key_exists('modified_at', $values) && !$this->is->unix_timestamp($values['modified_at'])) 	
			return $this->error->should_be_a_unix_timestamp($values['modified_at']);
		
		return true;
	}
	
	protected function _update($id, $values){
		return $this->db->update($this->table_name, $values, array('id' => $id, 'created_by' => $this->logged_in_user_id()));
	}
	
	protected function _delete($id){
		return $this->db->delete($this->table_name, array('id' => $id, 'created_by' => $this->logged_in_user_id())); 
	}
	
	function alias($list_id){
		if(!$this->formatted_like_an_id($list_id)) return $this->error->should_be_a_distribution_list_id($list_id);
		return 'pdl-'.$list_id;
	}
	
	function id_from_alias($alias){
		if(!$this->is->nonempty_string($alias)) return $this->error->should_be_a_nonempty_string($alias);
		return strip_from_beginning('pdl-', $alias);
	}
	
	function formatted_like_an_alias($alias){
		if(!$this->is->nonempty_string($alias)) return $this->error->should_be_a_nonempty_string($alias);
		return (string_begins_with('pdl-', $alias) && $this->formatted_like_an_id(strip_from_beginning('pdl-', $alias)));
	}	
	
}